//
//  MCStackPane.h
//  MCApplication
//
//  Created by Ali Lalani on Thu Jul 29 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCStackView.h"
#import "MCStackPaneHeader.h"
#import "MCStackPaneBody.h"
#import "MCStackAnimatingPaneHeader.h"
#import "MCStackViewDefines.h"

@interface MCStackPane : NSView {
	NSColor *bgColor; // background color, default is White
	
	MCStackPaneHeader *headerCollapsed;
	MCStackPaneHeader *headerExpanded;
	MCStackAnimatingPaneHeader *animatingHeader;
	MCStackPaneBody   *body;
	NSImage *bodyImage;
	
	float bodyFadeAnimationPercentDone;
	BOOL isFadingOut;
	
	NSString *_identifier;
	
	MCStackView *stackView;
}

+ (MCStackPane *)stackPane;
+ (MCStackPane *)stackPaneWithCollapsedHeader:(MCStackPaneHeader *)cHeaderView expandedHeader:(MCStackPaneHeader *)eHeaderView
										 body:(MCStackPaneBody *)bodyView;

// Animation //
- (void)animationWillBeginWithDirection:(BOOL)isMovingDown;
- (void)animationDidEnd;
- (void)fadeInBody;
- (void)fadeOutBody;

- (void)configureSubviews;

- (float)minimumHeight;
- (void)toggleCollapsedState; // tells the stack view to collapse or expand

// Frame for header as calculated by the stack pane's frame(doesn't take it directly from the header!)
- (NSRect)calculatedHeaderFrame;
// Frame for body as calculated by the stack pane's frame
- (NSRect)calculatedBodyFrame;

- (void)toggleSwitchHeaders;

// Config
- (void)configure;
- (void)setIdentifier:(NSString *)anIdentifier;
- (NSString *)identifier;

- (void)setBgColor:(NSColor *)aColor;
- (NSColor *)bgColor;

- (NSView *)currentHeaderView;

- (void)setHeaderCollapsed:(MCStackPaneHeader *)aHeader;
- (MCStackPaneHeader *)headerCollapsed;

- (void)setHeaderExpanded:(MCStackPaneHeader *)aHeader;
- (MCStackPaneHeader *)headerExpanded;

- (void)setBody:(MCStackPaneBody *)aBody;
- (MCStackPaneBody *)body;

- (MCStackView *)stackView;
- (void)setStackView:(MCStackView *)aStackView;

- (float)preferredYForSheet;
@end
